HDGLComputeMarketplaceCHGL2 Deployment Plan (Final v2 - Sep 30, 2025)
1. Ethereum Sepolia (L1 + CHG L2)

Environment: Hardhat v2.22.0, ethers.js v6.13.2, OpenZeppelin Upgrades v5.0.3, Certora Prover v0.12.0.
Contracts: HDGLComputeMarketplaceCHGL2.sol, MockZKVerifier.sol, MockCHGToken.sol.
Monolith: hdgl_monolith.c with zCHGsnark (BLS12-381, bulletproofs, ring signatures).
Steps:
Deploy mocks: npx hardhat run scripts/deploy_mocks.js --network sepolia
Deploy contract: npx hardhat run scripts/deploy_contract.js --network sepolia
Run LXC monolith: lxc-execute -n hdgl-aggregator -- ./hdgl_monolith --mode=aggregator
Test cases: Overflow (computeUnitsUsed >= 1e18), ZKP failures, superposition (0xFFFF0000), bulletproofs, ring signatures, stealth addresses.
Formal verification: certoraRun HDGLComputeMarketplaceCHGL2.sol --verify HDGLComputeMarketplaceCHGL2:HDGLComputeMarketplaceCHGL2.spec
Gas benchmarking: 3,500–5,500 gas per epochSubmit ($0.000875–$0.001375 at $2,500/ETH).



2. Solana Devnet

Port: hdgl_marketplace.rs (Rust/Anchor) for epochSubmit with commitment verification.
Monolith: Run hdgl_monolith.c with --rpc https://api.devnet.solana.com.
Steps: anchor build && anchor deploy --provider.cluster devnet
Test: Cross-chain hash consistency, ring signature verification.

3. LXC Deployment

AWS EC2: bash deploy_aws_lxc.sh (t3.medium aggregator, t3.micro nodes, AMI: ami-0e872aee57663ae2d).
GCP Compute Engine: bash deploy_gcp_lxc.sh (e2-medium aggregator, e2-micro nodes, project: hdgl-project-2025).
Nodes: Auto-scale to 10,000 via ASG/MIG.

4. Audit Preparation

Scope: Contract, monolith, zCHGsnark (BLS12-381, bulletproofs, ring signatures), LXC configs.
Provider: Quantstamp/Trail of Bits.
Test Cases:
Arithmetic overflow (computeUnitsUsed, counters).
ZKP failures (invalid pairing points, bulletproofs).
Superposition (D_3, D_7 resonance).
Ring signature anonymity (unlinkability).
Stealth address privacy.
Memory safety (GMP bounds, calloc/free).


Monitoring: Prometheus/Grafana for epoch/gas/ring signature tracking.

5. Production

Deploy on Ethereum mainnet post-audit.
Scale LXC nodes to 10,000+.
Integrate CHG-Solana bridge with ring signature support.
